
# Imports
import asyncio
import socket
import os
import sys
import json
import time
import serial

from pylog.pylogger import PyLogger

from py_pli.pylib import VUnits
from py_pli.pylib import send_msg
from py_pli.pylib import GlobalVar

from fleming.system_test.fle_sys import get_datafile
from fleming.system_test.fle_sys import setup_serial_mitutoyo
from fleming.system_test.fle_sys import read_value
from fleming.system_test.fle_sys import current_value
from fleming.system_test.fle_sys import max_value
from fleming.system_test.fle_sys import set_zero


INSTRUMENT = socket.gethostname()
PATH, SCRIPT = os.path.split(__file__)
BASE_NAME = SCRIPT.split('.')[0]
ADJUSTMENT_PATH = '/home/pkiuser/.config/pyrunner/'



# 1536 Well Positions
# FBD Top
A1_X = 71.96
A1_Y = 162.16
AF1_Y = 92.41
AF48__X = 177.71

# Logging and Messages
logger = PyLogger.logger
error_msg = f"Error Predefined Tasks in {BASE_NAME}."
start_msg = f"Start Predefined Task {BASE_NAME}."
info_msg = f"Information from {BASE_NAME}."
stop_msg = f"Stopped Predefined Task {BASE_NAME}."
complete_msg = f"Completed Predefined Task {BASE_NAME}."

# scan_table = VUnits.instance.hal.scan_table
# one_axis = VUnits.instance.hal.filterModuleSlider

# sample for predefined positions:
# els.GotoPosition(fms_enum.Positions.FixMirrorPosition_c)

# External Readout of Mitutoyo Sensor

async def log_sensor(count = 1):
    test = sys._getframe().f_code.co_name  # get function name from sys
    file_name = get_datafile(PATH, BASE_NAME, test)
    sensor = setup_serial_mitutoyo()
    for i in range(count):
        value = read_value(sensor)
        with open(file_name, 'a') as data:
            print(f'{i+1:03d};{value}')
            data.write(f'{value} \n')

async def display_sensor(count = 1):
    sensor = setup_serial_mitutoyo()
    for i in range(count):
        value = read_value(sensor)
        print(f'{i+1:03d}: {value}')

async def zero_test():
    sensor = setup_serial_mitutoyo()
    value1 = read_value(sensor)
    response = set_zero(sensor)
    value2 = read_value(sensor)
    print(f'{value1}, {response}, {value2}')
    return




############################
# High Level Test Functions
############################

# Untested Functions


async def st_move_log(direction = 'y', profile = 0, y_range: float = 8.0, step = 0.1):
    # Moves scantable for range mm in direction (positive) and logs position from mitutoyo-sensor

    # !! Scantable has to be positioned before starting the script !!

    # direction: Movement direction to test: x; y
    # profile: Motor profile for movement
    # range. mm to move in x
    # step: Step to move
    test = sys._getframe().f_code.co_name  # get function name from sys
    st = VUnits.instance.hal.scan_table
    st.ReloadConfig()
    await st.InitializeDevice()
    taster = serial.Serial(port = SERIAL_PORT, baudrate=BAUDRATE, bytesize=BYTESIZE, timeout=2, parity=PARITY, stopbits=STOPBITS)
    data_filename = get_datafile(PATH, BASE_NAME, test)
    x, y = await st.GetPosition()
    delay = 0.1
    # await st.UseProfile(1)
    # await st.Move(5.0,5.0)
    # await st.Home()
    # await st.UseProfile(0)
    # await st.Move(x, y)
    time.sleep(delay)
    no_steps = int(y_range / step)
    try:

        with open (data_filename, 'a') as data:
            # First Position Value
            data.write(f'no;st_x;st_y;pos;\n')
            response = set_zero(taster)
            print(f'Taster set to zero {response}')
            taster_value = read_value(taster)
            data.write(f'0000;{x};{y};{taster_value}\n')
            time.sleep(delay)
            # Move in X/Y stepwise
            await st.UseProfile(profile)
            for nr in range(no_steps):
                if direction == 'y':
                    y += step
                elif direction == 'x':
                    x += step
                else:
                    return('stopped by user')
                await st.Move(x, y)
                time.sleep(delay)
                taster_value = read_value(taster)
                record = f'{(nr+1):04d};{x:7.3f};{y:7.3f};{taster_value}\n'
                data.write(record)
                print(record)
            for nr in range(no_steps, 0, -1):
                if direction == 'y':
                    y -= step
                elif direction == 'x':
                    x -= step
                else:
                    return('stopped by user')
                await st.Move(x, y)
                time.sleep(delay)
                taster_value = read_value(taster)
                record = f'{nr:04d};{x:7.3f};{y:7.3f};{taster_value}\n'
                data.write(record)
                print(record)

    except Exception as ex:
        print(f"something's going wrong this way: {ex}") 
        return(ex)   
    
    print(f'Testscript {test} finished with no errors, result written to {data_filename}')
    return(data_filename)

async def st_move_pattern(pattern_file = 'positions.json', profile = 1, time_to_wait=1):
    await send_msg(json.dumps(start_msg))
    
    # Initializing Scantable
    st = VUnits.instance.hal.scan_table
    st.ReloadConfig()
    await st.InitializeDevice()
    await st.UseProfile(profile)

    with open(pattern_file, 'r') as f:
        position_list = json.load(f)
    await VUnits.instance.hal.focusMover.Home()
    await VUnits.instance.hal.usLumFocusMover.Home()
    for position in sorted(position_list.keys(), key=int):
        x, y = position_list[position]
        msg_text = f'Move to Position {x}, {y}'
        msg = {'result': f'{msg_text}'}
        await send_msg(json.dumps(msg))
        await VUnits.instance.hal.scan_table.Move(x, y)
        msg = {'result': f'wait {time_to_wait}s...'}
        await send_msg(json.dumps(msg))
        await asyncio.sleep(time_to_wait)
    msg = {'result': f'finished !'}
    await send_msg(json.dumps(msg))


'''
async def bigbelt_backlash(start =3.0, profile = 0, y_range: float = 8.0, step = 0.1):
    # Moves Envision Axis (FilterModuleSlider Unit) from start for range mm  and logs position from mitutoyo-sensor
    # start: start  -> 3
    # profile: Motor profile for movement
    # range. mm to move in x
    # step: Step to move
    test = sys._getframe().f_code.co_name  # get function name from sys
    axis = VUnits.instance.hal.filterModuleSlider
    axis.ReloadConfig()
    await axis.InitializeDevice()
    taster = serial.Serial(port = SERIAL_PORT, baudrate=BAUDRATE, bytesize=BYTESIZE, timeout=2, parity=PARITY, stopbits=STOPBITS)
    data_filename = get_datafile(PATH, BASE_NAME, test)
    x = start
    delay = 0.1
    print(f'Testscript {test} started...')
    # await axis.UseProfile(1)
    # await axis.Move(5.0)
    # await axis.Home()
    await axis.UseProfile(profile)
    await axis.Move(x)
    time.sleep(delay)
    no_steps = int(y_range / step)
    try:

        with open (data_filename, 'a') as data:
            # First Position Value
            data.write(f'no;st_x;pos;\n')
            response = set_zero(taster)
            print(f'Taster set to zero {response}')
            taster_value = read_value(taster)
            data.write(f'0000;{x};{taster_value}\n')
            time.sleep(delay)
            # Move in X/Y stepwise
            # await axis.UseProfile(profile)
            for nr in range(no_steps):
                x += step
                await axis.Move(x)
                time.sleep(delay)
                taster_value = read_value(taster)
                record = f'{(nr+1):04d};{x:.3f};{taster_value}\n'
                data.write(record)
                print(record)
            for nr in range(no_steps, 0, -1):
                x -= step
                await axis.Move(x)
                time.sleep(delay)
                taster_value = read_value(taster)
                record = f'{nr:04d};{x:.3f};{taster_value}\n'
                data.write(record)
                print(record)

    except Exception as ex:
        print(f"something's going wrong this way: {ex}") 
        return(ex)   
    
    print(f'Testscript {test} finished with no errors, result written to {data_filename}')
    return(data_filename)

 
async def scantable_zig_zag(direction = 'y', start_x = 10, start_y = 10, profile = 0, step_count = 1, step_distance = 1):
    # Setup Hardware and initialize it

    test = sys._getframe().f_code.co_name  # get function name from sys
    st = VUnits.instance.hal.scan_table
    st.ReloadConfig()
    st.InitializeDevice()
    taster = serial.Serial(port = SERIAL_PORT, baudrate=BAUDRATE, bytesize=BYTESIZE, timeout=2, parity=PARITY, stopbits=STOPBITS)
    data_filename = get_datafile(PATH, BASE_NAME, test)

    # Setup Start Conditions

    x = start_x
    y = start_y
    delay = 0.1
    print(f'Testscript {test} started...')
    await st.UseProfile(1)
    # await st.Move(5.0,5.0)
    await st.Home()
    await st.UseProfile(0)
    await st.Move(x, y)
    time.sleep(delay)
    step_dir = 1

    # Start Measuring Loop
    try:

        with open (data_filename, 'a') as data:
            # First Position Value
            data.write(f'no;st_x;st_y;pos;\n')
            response = set_zero(taster)
            print(f'Taster set to zero {response}')
            taster_value = read_value(taster)
            data.write(f'0000;{x};{y};{taster_value}\n')
            time.sleep(delay)
            
            # Move in X/Y stepwise
            await st.UseProfile(profile)
            
            # Move forward
            for nr in range(step_count):
                if direction == 'y':
                    # Move in first direction
                    y += step_distance
                    await st.Move(x, y)
                    time.sleep(delay)
                    taster_value = read_value(taster)
                    record = f'{(nr+1):04d};{x:7.3f};{y:7.3f};{taster_value}\n'
                    data.write(record) 
                    print(record)
                    # set second direction
                    x += step_dir * step_distance
                    # move second direction
                    await st.Move(x, y)
                    time.sleep(delay)
                    taster_value = read_value(taster)
                    record = f'{(nr+1):04d};{x:7.3f};{y:7.3f};{taster_value}\n'
                    data.write(record) 
                    print(record)

                elif direction == 'x':
                    x += step
                    await st.Move(x, y)
                    time.sleep(delay)
                    taster_value = read_value(taster)
                    record = f'{(nr+1):04d};{x:7.3f};{y:7.3f};{taster_value}\n'
                    data.write(record) 
                    print(record)
                    # set second direction
                    y += step_dir * step_distance
                    # move second direction
                    await st.Move(x, y)
                    time.sleep(delay)
                    taster_value = read_value(taster)
                    record = f'{(nr+1):04d};{x:7.3f};{y:7.3f};{taster_value}\n'
                    data.write(record) 
                    print(record)

                step_dir *= (-1) # change direction for next step
    
    except Exception as ex:
        print(f"something's going wrong this way: {ex}") 
        return(ex)   
    
    print(f'Testscript {test} finished with no errors, result written to {data_filename}')
    return(data_filename)
                
async def scantable_positioning(well_x = 1, well_y = 1):
    # scan_table.SetPlateType("'96 Multilabel Test Plate 1.2'")
        # Setup Hardware and initialize it

    test = sys._getframe().f_code.co_name  # get function name from sys
    st = VUnits.instance.hal.scan_table
    st.ReloadConfig()
    st.InitializeDevice()
    taster = serial.Serial(port = SERIAL_PORT, baudrate=BAUDRATE, bytesize=BYTESIZE, timeout=2, parity=PARITY, stopbits=STOPBITS)
    data_filename = get_datafile(PATH, BASE_NAME, test)
    plate_type = '96 Multilabel Test Plate 1.2'
    x = 75.38
    y = 158.76
    delay = 0.1
    print(f'Testscript {test} started...')
    await st.UseProfile(1)
    await st.Move(5.0,5.0)
    await st.Home()
    await st.UseProfile(0)
    await st.Move(x, y)
    try:

        with open (data_filename, 'a') as data:
            # First Position Value
            data.write(f'no;st_x;st_y;pos;\n')
            response = set_zero(taster)
            print(f'Taster set to zero {response}')
            time.sleep(delay)
            for nr in range(12):
                taster_value = read_value(taster)
                record = f'{(nr):04d};{x:7.3f};{y:7.3f};{taster_value}\n'

    except Exception as ex:
        print(f'Exception {ex}')
        return

async def st_cartesian_mode(c_mode = 1):
    # set cartesian mode of scantable
    # 2023-10-05/kstruebing

    st = VUnits.instance.hal.scan_table
    st.ReloadConfig()
    st.InitializeDevice()
    try:

        st.CoreXY.cartesianMode = c_mode
        print(f'Scantable Cartesian Mode = {c_mode}')
        return

    except Exception as ex:
        st.CoreXY.cartesianMode = True
        print(f'Exception {ex}, \n Scantable Cartesian Mode = {c_mode}')
        return
    
    
   
async def st_diagonal(cartesian = 0, profile = 1, move_range = 6, resolution = 0.1):
    """
    Testscript for diagonal movement
    Scantable moves from current position without homing
    2023-10-05/kstruebing
    Lief schon mal am 06.10.2023

    """
    test = sys._getframe().f_code.co_name  # get function name from sys
    st = VUnits.instance.hal.scan_table
    st.ReloadConfig()
    await st.InitializeDevice()
    taster = serial.Serial(port = SERIAL_PORT, baudrate=BAUDRATE, bytesize=BYTESIZE, timeout=2, parity=PARITY, stopbits=STOPBITS)
    data_filename = get_datafile(PATH, BASE_NAME, test)
    num_of_steps = int(move_range / resolution)
    delay = 0.1
    # x = 170.0
    # y = 0.0
    
    try:

        await st.UseProfile(profile)
        x, y = await st.GetPosition()
        st.CoreXY.cartesianMode = cartesian
        with open (data_filename, 'a') as data:
            # First Position Value
            data.write(f'no;st_x;st_y;pos;\n')
            response = set_zero(taster)
            print(f'Taster set to zero {response}')

            for i in range (num_of_steps): # FORWARD MOVEMENT
                await st.Move(x, y)
                time.sleep(delay)
                taster_value = read_value(taster)
                data.write(f'{i:04d};{x:.3f};{y:.3f};{taster_value}\n')
                x -= resolution
                y += resolution
            for i in range(num_of_steps, -1, -1): # REVERSE MOVEMENT
                await st.Move(x, y)
                time.sleep(delay)
                taster_value = read_value(taster)
                data.write(f'{i:04d};{x:.3f};{y:.3f};{taster_value}\n')
                x += resolution
                y -= resolution


        st.CoreXY.cartesianMode = True
        return

    except Exception as ex:
        st.CoreXY.cartesianMode = True

        return(ex)
'''
